<?php
/*
Plugin Name: Honeypot Comments Logger Custom
Description: Añade un campo honeypot invisible al formulario de comentarios y registra intentos de spam bloqueados.
Version: 1.0
Author: Francisco
*/

if ( ! defined( 'ABSPATH' ) ) exit; // Seguridad

// Añadir campo honeypot al formulario de comentarios
add_action('comment_form', function() {
    echo '<p class="honeypot-field" style="display:none;">
        <label for="hp_email">Si eres humano, deja este campo vacío</label>
        <input type="text" name="hp_email" id="hp_email" value="" />
    </p>';
});

// Validar antes de guardar el comentario
add_filter('preprocess_comment', function($comment) {
    if (!empty($_POST['hp_email'])) {
        // Registrar intento bloqueado
        $count = (int) get_option('honeypot_blocked_count', 0);
        update_option('honeypot_blocked_count', $count + 1);

        wp_die('Spam detectado y bloqueado por Honeypot.');
    }
    return $comment;
});

// Añadir página de estadísticas en el menú de administración
add_action('admin_menu', function() {
    add_menu_page(
        'Honeypot Stats',
        'Honeypot Stats',
        'manage_options',
        'honeypot-stats',
        'honeypot_stats_page',
        'dashicons-shield',
        80
    );
});

// Contenido de la página de estadísticas
function honeypot_stats_page() {
    $count = (int) get_option('honeypot_blocked_count', 0);
    echo '<div class="wrap"><h1>Estadísticas Honeypot</h1>';
    echo '<p>Comentarios de spam bloqueados: <strong>' . $count . '</strong></p>';
    echo '</div>';
}
add_filter('site_transient_update_plugins', function($value) {
    if (isset($value->response[plugin_basename(__FILE__)])) {
        unset($value->response[plugin_basename(__FILE__)]);
    }
    return $value;
});
